/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.impl.FcsInternalConstants;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Map;

public class ServiceThread
implements FcsInternalConstants {
    private static final String TRACE_MASKD = "XFCSSTHD";
    private static final String TRACE_MASKT = "XFCSSTHT";
    private static final String TRACE_MASKF = "XFCSSTHF";
    private Connection connection;
    private Map map;
    private String oldThreadName;

    public ServiceThread(Connection connection, Map map) {
        this.connection = connection;
        this.map = map;
        this.oldThreadName = Thread.currentThread().getName();
    }

    public void process() {
        Thread.currentThread().setName("FCS - ServiceThread: Unassociated");
        try {
            if (this.connection != null) {
                FcsConnection fcsConnection = FcsConnection.associate(this.map, this.connection);
                Trace.trace(TRACE_MASKD, "Passing new thread to service: " + (FcsServiceId)this.map.get("serviceId"));
                Thread.currentThread().setName("FCS - ServiceThread: " + fcsConnection.getConnectionId());
                FcsServiceId serviceId = (FcsServiceId)this.map.get("serviceId");
                if (FcsServer.getFcsServer().isBlackListed(fcsConnection.getMachineId())) {
                    Trace.trace(TRACE_MASKF, "FCS received a connection from a blacklisted machine.  Closing the socket. " + fcsConnection.getMachineId());
                    this.connection.close();
                } else {
                    FcsService service;
                    if (!FcsServer.getFcsServer().getMachineList().contains(fcsConnection.getMachineId()) && !serviceId.getServiceName().equals("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken")) {
                        DiscoveryCenter.getDiscoveryCenter().foundAddresses(fcsConnection.getMachineId().getNicAddresses(), DiscoveryCenter.fcsInternallyDiscovered);
                    }
                    if ((service = FcsServer.getFcsServer().getService(serviceId)) != null) {
                        Trace.trace(TRACE_MASKD, "service wasn't null, processing connection");
                        Thread.currentThread().setName("FCS - ServiceThread (" + fcsConnection.getConnectionId() + ") for service: " + serviceId.getServiceName() + ", " + serviceId.getVersion());
                        UserContext uc = UserContext.getCurrentUserContext();
                        UserContext ucnew = new UserContext(null, uc.getAddress(), 3, uc.getID(), uc.getLocale());
                        ucnew.attachToThread();
                        service.processConnection(fcsConnection);
                    } else {
                        Trace.trace(TRACE_MASKD, "service was null, closing connection");
                        this.connection.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Trace.trace(TRACE_MASKF, "Error during handshaking: " + t.getMessage());
        }
        Thread.currentThread().setName(this.oldThreadName);
    }
}

